#extension GL_ARB_shading_language_420pack: enable 

varying vec4 		texcoord;
uniform ivec4 		maskUV;
uniform ivec4 		layerUV;

uniform sampler2D 	dif0,
					bmp0;
					
#ifdef ALPHATEST
	//uniform sampler2D 	noisemap;
#endif
	
#ifdef _HEIGHTMAP_	
	uniform sampler2D	heightmap;
#else
	uniform sampler2D	thickness;
#endif

uniform float		metal0;
uniform vec2		fresnel0,
					spec0;
uniform vec4		dcolor0,
					scolor0;
uniform vec2		dscale0,
					bscale0;
uniform vec2		dofs0,
					bofs0;
uniform float 		backScatter;
uniform vec2 		scatterlevel;
uniform float		matID;

#ifdef VEGETATION
	#ifndef BSET
		#ifndef MSET
			varying vec3	vgColor;
		#endif
	#endif
#endif
	
#ifdef ALPHATEST

	uniform float 		alphalevel;
	varying float		alphaFade;
	
#endif

#ifdef MACROBUMP
uniform vec2 		addBaseNormal;
#endif

#ifdef MACRODIFFUSE
uniform float		mulBaseDiffuse;
#endif

#ifdef PSYSTEM

	varying float 	life;
	varying float	cosa,
					sina;
	uniform vec4 		particleFade;
				
#else

	#ifdef BSET

		varying vec4 pnormal;
		varying vec4 pcolor;
		
		/////////////////////
		varying mat3	TBN;
		////////////////////
		
	#else
	
		varying mat3	TBN;
		
		#ifdef MSET
		varying vec4 pcolor;
		uniform float terrainColorAmount;
		#else
			varying float occlusion; 
		#endif
		
	#endif
		
#endif				


#ifdef LAYER1

	uniform float		metal1;
	uniform vec3		maskMul;

	uniform sampler2D 	lmask;
	uniform sampler2D 	dif1,
						bmp1;
	uniform vec2		fresnel1,
						spec1;
	uniform vec4		dcolor1,
						scolor1;
	uniform vec2		dscale1,
						bscale1;
	uniform vec2		dofs1,
						bofs1;
						
	uniform vec4		lParams1;
						
	#ifdef LAYER2
		uniform float		metal2;
		uniform sampler2D 	dif2,
							bmp2;
		uniform vec2		fresnel2,
							spec2;
		uniform vec4		dcolor2,
							scolor2;
		uniform vec2		dscale2,
							bscale2;
		uniform vec2		dofs2,
					bofs2;		
		uniform vec4		lParams2;							
							
		#ifdef LAYER3
			uniform float		metal3;
			uniform sampler2D 	dif3,
								bmp3;
			uniform vec2		fresnel3,
								spec3;
			uniform vec4		dcolor3,
								scolor3;
			uniform vec2		dscale3,
								bscale3;
			uniform vec2		dofs3,
								bofs3;
			uniform vec4		lParams3;	
		#endif

	#endif

#endif


#ifdef _HEIGHTMAP_

	uniform sampler2D	baseTex;
	uniform sampler2D	cmask;

	uniform vec4 		baseFarCoords;			// x,y tile coords, z,w slope height fallof
	varying vec2 		baseCoords;
	uniform vec4		baseTexParams;
	
	varying float		NWheight;
	uniform float		baseGloss;
	uniform float 		bumpScale;
	
	uniform vec2		invHeightmapSize;
	
	#ifdef LAYER1
	uniform vec2		slopeHeightfallof1;
						
		#ifdef LAYER2
			uniform vec2		slopeHeightfallof2;							
								
			#ifdef LAYER3
				uniform vec2		slopeHeightfallof3;	
			#endif

		#endif
		
	#endif

#endif


varying vec4 		curpos,
					pos;
uniform float 		fade;

float SPECULAR_OFFSET=0.05;

// NOISE ----------------------------------------------------
float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a) (bayer64(.5*(a))*.25+bayer2(a))
// -----------------------------------------------------------

vec2 encode(vec3 n)
{
	n=normalize(n);
    float f = sqrt(8.0*n.z+8.0);
    return n.xy / f + 0.5;
}

vec3 blend3D(vec4 tex1, vec4 tex2, float alpha)
{
	float depth=0.2;
	float ma=max(tex1.a+(1.0-alpha),tex2.a+alpha)-depth;
	
	float b1=max(tex1.a + (1.0-alpha) - ma,0.0);
	float b2=max(tex2.a + alpha - ma,0.0);
	
	return (tex1.rgb*b1 + tex2.rgb*b2)/(b1+b2);
}

vec2 blend2D(vec2 tex1, vec2 tex2, float a1, float a2, float alpha)
{
	float depth=0.2;
	float ma=max(a1+(1.0-alpha),a2+alpha)-depth;
	
	float b1=max(a1 + (1.0-alpha) - ma,0.0);
	float b2=max(a2 + alpha - ma,0.0);
	
	return (tex1*b1 + tex2*b2)/(b1+b2);
	//return (a1+(1.0-alpha)) > (a2+alpha) ? tex1 : tex2;
}

float blend1D(float f1, float f2, float a1, float a2, float alpha)
{
	float depth=0.2;
	float ma=max(a1+(1.0-alpha),a2+alpha)-depth;
	
	float b1=max(a1 + (1.0-alpha) - ma,0.0);
	float b2=max(a2 + alpha - ma,0.0);
	
	return (f1*b1 + f2*b2)/(b1+b2);
	//return (a1+(1.0-alpha)) > (a2+alpha) ? f1 : f2;
}

void main()
{
	//vec2 screenCoords=prev.xy;
	
	#ifdef PSYSTEM
	
		if(life<=0.0)
			discard;
			
	#endif

	//vec2 screenCoords=curpos.xy*0.5+0.5;
	
	vec4 	texcolor;
	vec4 	fdcolor,
			fbcolor;
	vec3	fnormal;
	vec2	fspec,
			ffresnel;
	float 	metal,
			basemetal;//=metal0;
			
	#ifndef _HEIGHTMAP_		
		#ifdef MACRODIFFUSE	
			vec4 baseColor=texture2D(dif0,/*texcoord.st*/vec2(texcoord[layerUV.x],texcoord[layerUV.x+1])*dscale0+dofs0);
			baseColor.rgb=pow(baseColor.rgb,vec3(2.2))*dcolor0.rgb;
			fdcolor=vec4(1.0,1.0,1.0,baseColor.a);
		#else
			fdcolor=texture2D(dif0,/*texcoord.st*/vec2(texcoord[layerUV.x],texcoord[layerUV.x+1])*dscale0+dofs0);
			fdcolor.rgb=pow(fdcolor.rgb,vec3(2.2))*dcolor0.rgb;
		#endif
	#endif
	
	#ifdef ALPHATEST

		#ifdef PSYSTEM
			float alpha=fdcolor.a*life;
			if(alpha<=alphalevel)
				discard;
		#else
			#ifdef BSET
				float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,curpos.st*vec2(10.0/*0.0125)*/).r;
				if(alpha>pcolor.w)
					discard;
			#else
				#ifdef MSET
					float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,curpos.st*vec2(10.0/*0.0125*/)).r;
					if(alpha>fade)
						discard;
				#else
					#ifdef _HEIGHTMAP_
					#else
						#ifdef SKINNING
						#else
							#ifndef _NOT_INSTANCED_
								float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,curpos.st*vec2(10.0/*0.0125*/)).r;
								if(alpha>alphaFade)
									discard;
							#else
								float alpha=bayer4(gl_FragCoord.st);//texture2D(noisemap,curpos.st*vec2(10.0/*0.0125*/)).r;
								if(alpha>fade)
									discard;
							#endif
						#endif
					#endif
				#endif
			#endif
			
			#ifdef BSET
				if(fdcolor.a<=alphalevel)
					discard;
			#else
				if(fdcolor.a<=mix(alphalevel,alphalevel*0.8,clamp(curpos.z*25000.0-4500.0,0.0,1.0)))
					discard;
			#endif
		#endif
		
	#endif

	#ifdef MACROBUMP
		
		vec4 baseNormal=texture2D(bmp0,vec2(texcoord[layerUV.x],texcoord[layerUV.x+1])*bscale0+bofs0);
		baseNormal.xy=(baseNormal.xy*2.0-1.0);
		fnormal=vec3(0,0,0);
		ffresnel.x=fresnel0.x;//*(baseNormal.a+SPECULAR_OFFSET);
		ffresnel.y=fresnel0.y*baseNormal.z;
		metal=metal0*baseNormal.a;
		basemetal=metal;
		baseNormal.z=sqrt(1.0-baseNormal.x*baseNormal.x-baseNormal.y*baseNormal.y);
		vec2 baseFresnel=ffresnel;
 
	#else

		#ifdef BSET
		
		#else
			fbcolor=texture2D(bmp0,vec2(texcoord[layerUV.x],texcoord[layerUV.x+1])*bscale0+bofs0);
			fnormal.xy=(fbcolor.xy*2.0-1.0);
		#endif

		ffresnel.x=fresnel0.x;//*(fbcolor.a+SPECULAR_OFFSET);
		ffresnel.y=fresnel0.y*fbcolor.z;
		metal=metal0*fbcolor.a;

	#endif

	#ifdef _HEIGHTMAP_
	
	/* PROVA NORMAL COMPUTATION */
		float 	h00,
				h10,
				h01;
		h00=texture2D(heightmap,texcoord.st).r;
		h10=texture2D(heightmap,texcoord.st+vec2(invHeightmapSize.x,0.0)).r;
		h01=texture2D(heightmap,texcoord.st+vec2(0.0,invHeightmapSize.y)).r;
		
		vec3 binormal3=(vec3(invHeightmapSize.x*bumpScale,0.0,h10)-vec3(0.0,0.0,h00));
		vec3 tangent3=(vec3(0.0,invHeightmapSize.y*bumpScale,h01)-vec3(0.0,0.0,h00));
		vec3 normal3=normalize(cross(binormal3,tangent3));
		normal3.y=-normal3.y;
		
		float t=clamp(-pos.z*0.000025,0.0,1.0);
		float t0=clamp(-pos.z*0.0005,0.0,1.0);
		
		vec2 texcoord0=texcoord.st*bscale0+bofs0;
		vec4 detailNormal=texture2D(bmp0,texcoord0*8.0);
		detailNormal.xy=(detailNormal.xy*2.0-1.0);
		fbcolor=texture2D(bmp0,texcoord.st*baseFarCoords.xy);
		
		ffresnel.y=mix(ffresnel.y,fresnel0.y*fbcolor.z,t);
		ffresnel.y=mix(fresnel0.y*detailNormal.z,ffresnel.y,t0);
		
		detailNormal.z=0.0;
		
		fbcolor.xy=(fbcolor.xy*2.0-1.0);
		fbcolor.z=sqrt(1.0-fbcolor.x*fbcolor.x-fbcolor.y*fbcolor.y);
		
		fnormal.z=sqrt(1.0-fnormal.x*fnormal.x-fnormal.y*fnormal.y);
	
		fnormal=fbcolor.xyz + fnormal + detailNormal.xyz;		
		vec4 f0=texture2D(dif0,texcoord.st*baseFarCoords.xy);
		f0.rgb=pow(f0.rgb,vec3(2.2));
		vec3 baseNormal=fnormal;
		
		////////////////// baseFarCoords.zw slope & height fallof
		float dotNUp=abs(normal3.z);
		float vSlope;
		float vSlopeHeight;
		float Mfallof=1.0-clamp((dotNUp-baseTexParams.x)/baseFarCoords.z,0.0,1.0);
		float mfallof=clamp((dotNUp-(baseTexParams.z-baseFarCoords.z))/baseFarCoords.z,0.0,1.0);
		vSlope=1.0-(clamp(step(baseTexParams.z,dotNUp)+mfallof,0.0,1.0)*clamp(step(dotNUp,baseTexParams.x)+Mfallof,0.0,1.0));//clamp( pow((dotNUp-baseTexParams.x)/baseTexParams.x,baseFarCoords.z), 0.0,1.0);			// 4.0 - baseFarCoords.z = slope fallof
		Mfallof=1.0-clamp((NWheight-baseTexParams.y)/baseFarCoords.w,0.0,1.0);
		mfallof=clamp((NWheight-(baseTexParams.w-baseFarCoords.w))/baseFarCoords.w,0.0,1.0);
		vSlopeHeight=vSlope*( clamp(step(baseTexParams.w,NWheight)+mfallof,0.0,1.0)*clamp(step(NWheight,baseTexParams.y)+Mfallof,0.0,1.0));
		//////////////////
		
		fbcolor.xyz=vec3(0.0,0.0,1.0);
		fnormal=mix(normalize(fnormal),fbcolor.xyz,vSlopeHeight);
		
		texcoord0=texcoord.st*dscale0+dofs0;
		vec4 fdcolor0=texture2D(dif0,texcoord0);
		fdcolor0.rgb=pow(fdcolor0.rgb,vec3(2.2));
		fdcolor0=mix(fdcolor0,f0,t);
		
		fdcolor=texture2D(dif0,texcoord0*8.0);
		fdcolor.rgb=pow(fdcolor.rgb,vec3(2.2))*dcolor0.rgb;
		fdcolor=mix(fdcolor,fdcolor0,t0);
		
		vec4 baseColor=texture2D(baseTex,baseCoords);
		baseColor.rgb=pow(baseColor.rgb,vec3(2.2));
		
		//float alphat=mix(baseColor.a,1.0,t);
				
		fdcolor.xyz=blend3D(fdcolor,baseColor,vSlopeHeight);
		ffresnel.x=blend1D(ffresnel.x,baseColor.a*baseGloss,fdcolor.a,fdcolor.a*baseColor.a,vSlopeHeight);
		
		float vSlope1=0.0;
		float vSlope2=0.0;
		float vSlope3=0.0;
				
	#endif

	float rangeMin=scatterlevel.y-3000.0;
	#ifdef LAYER1

		vec3 	mask=vec3(1.0,1.0,1.0);
		vec3 	fadedmask;
		if(-pos.z<scatterlevel.y)
		{
			mask.r=clamp(texture2D(lmask,vec2(texcoord[maskUV.y],texcoord[maskUV.y+1])).r*maskMul.r,0.0,1.0);
			fadedmask.r=mix(mask.r,0.0,( clamp( (-pos.z-rangeMin)/3000.0,0.0,1.0) ));
			//vec3	compMask;
						
			texcolor=texture2D(dif1,vec2(texcoord[layerUV.y],texcoord[layerUV.y+1])*dscale1+dofs1);
			texcolor.rgb=pow(texcolor.rgb,vec3(2.2));
		//	fadedmask.r*=texcolor.a;
			
			#ifdef _HEIGHTMAP_
				Mfallof=1.0-clamp((dotNUp-lParams1.x)/slopeHeightfallof1.x,0.0,1.0);
				mfallof=clamp((dotNUp-(lParams1.z-slopeHeightfallof1.x))/slopeHeightfallof1.x,0.0,1.0);
				vSlope=(clamp(step(lParams1.z,dotNUp)+mfallof,0.0,1.0)*clamp(step(dotNUp,lParams1.x)+Mfallof,0.0,1.0));//clamp( pow((dotNUp-baseTexParams.x)/baseTexParams.x,baseFarCoords.z), 0.0,1.0);			// 4.0 - baseFarCoords.z = slope fallof
				Mfallof=1.0-clamp((NWheight-lParams1.y)/slopeHeightfallof1.y,0.0,1.0);
				mfallof=clamp((NWheight-(lParams1.w-slopeHeightfallof1.y))/slopeHeightfallof1.y,0.0,1.0);
				vSlopeHeight=vSlope*( clamp(step(lParams1.w,NWheight)+mfallof,0.0,1.0)*clamp(step(NWheight,lParams1.y)+Mfallof,0.0,1.0));
				fadedmask.r=vSlopeHeight*fadedmask.r;
				
			#endif
			
			//compMask.r=1.0-fadedmask.r;
			fdcolor.xyz=blend3D(fdcolor,texcolor*dcolor1,fadedmask.r);
			fbcolor=texture2D(bmp1,vec2(texcoord[layerUV.y],texcoord[layerUV.y+1])*bscale1+bofs1);
			fnormal.xy=blend2D(fnormal.xy,(fbcolor.xy*2.0-1.0),fdcolor.a,texcolor.a,fadedmask.r);
			
		//	#ifndef MACROBUMP
				ffresnel.y=blend1D(ffresnel.y,fresnel1.y*fbcolor.z,fdcolor.a,texcolor.a,fadedmask.r);
				ffresnel.x=blend1D(ffresnel.x,fresnel1.x/*(fbcolor.a+SPECULAR_OFFSET)*/,fdcolor.a,texcolor.a,fadedmask.r);
		//	#endif
				
			metal=blend1D(metal,metal1*fbcolor.a,fdcolor.a,texcolor.a,fadedmask.r);//mix(metal,metal1,fadedmask.r);//metal=metal1*fadedmask.r + (compMask.r)*metal;
			
			#ifdef LAYER2
			
				mask.g=clamp(texture2D(lmask,vec2(texcoord[maskUV.z],texcoord[maskUV.z+1])).g*maskMul.g,0.0,1.0);
				fadedmask.g=mix(mask.g,0.0,( clamp( (-pos.z-rangeMin)/3000.0,0.0,1.0) ));
				texcolor=texture2D(dif2,/*texcoord.st*/vec2(texcoord[layerUV.z],texcoord[layerUV.z+1])*dscale2+dofs2);
				texcolor.rgb=pow(texcolor.rgb,vec3(2.2));
			//	fadedmask.g*=texcolor.a;
				
				#ifdef _HEIGHTMAP_
			
					Mfallof=1.0-clamp((dotNUp-lParams2.x)/slopeHeightfallof2.x,0.0,1.0);
					mfallof=clamp((dotNUp-(lParams2.z-slopeHeightfallof2.x))/slopeHeightfallof2.x,0.0,1.0);
					vSlope=/*1.0-*/(clamp(step(lParams2.z,dotNUp)+mfallof,0.0,1.0)*clamp(step(dotNUp,lParams2.x)+Mfallof,0.0,1.0));//clamp( pow((dotNUp-baseTexParams.x)/baseTexParams.x,baseFarCoords.z), 0.0,1.0);			// 4.0 - baseFarCoords.z = slope fallof
					Mfallof=1.0-clamp((NWheight-lParams2.y)/slopeHeightfallof2.y,0.0,1.0);
					mfallof=clamp((NWheight-(lParams2.w-slopeHeightfallof2.y))/slopeHeightfallof2.y,0.0,1.0);
					vSlopeHeight=vSlope*( clamp(step(lParams2.w,NWheight)+mfallof,0.0,1.0)*clamp(step(NWheight,lParams2.y)+Mfallof,0.0,1.0));
					fadedmask.g=vSlopeHeight*fadedmask.g;
				
				#endif
				
				//compMask.g=1.0-fadedmask.g;
				fdcolor.xyz=blend3D(fdcolor,texcolor*dcolor2,fadedmask.g);
				fbcolor=texture2D(bmp2,vec2(texcoord[layerUV.z],texcoord[layerUV.z+1])*bscale2+bofs2);
				fnormal.xy=blend2D(fnormal.xy,(fbcolor.xy*2.0-1.0),fdcolor.a,texcolor.a,fadedmask.g);
				
			//	#ifndef MACROBUMP
					ffresnel.y=blend1D(ffresnel.y,fresnel2.y*fbcolor.z,fdcolor.a,texcolor.a,fadedmask.g);
					ffresnel.x=blend1D(ffresnel.x,fresnel2.x/*(fbcolor.a+SPECULAR_OFFSET)*/,fdcolor.a,texcolor.a,fadedmask.g);
			//	#endif
				metal=blend1D(metal,metal2*fbcolor.a,fdcolor.a,texcolor.a,fadedmask.g);//metal=mix(metal,metal2,fadedmask.g);//metal=metal2*fadedmask.g + (compMask.g)*metal;
				
				#ifdef LAYER3
				
					mask.b=clamp(texture2D(lmask,vec2(texcoord[maskUV.w],texcoord[maskUV.w+1])).b*maskMul.b,0.0,1.0);
					fadedmask.b=mix(mask.b,0.0,( clamp( (-pos.z-rangeMin)/3000.0,0.0,1.0) ));
					texcolor=texture2D(dif3,vec2(texcoord[layerUV.w],texcoord[layerUV.w+1])*dscale3+dofs3);
					texcolor.rgb=pow(texcolor.rgb,vec3(2.2));
					//fadedmask.b*=texcolor.a;
				
					#ifdef _HEIGHTMAP_
			
						Mfallof=1.0-clamp((dotNUp-lParams3.x)/slopeHeightfallof3.x,0.0,1.0);
						mfallof=clamp((dotNUp-(lParams3.z-slopeHeightfallof3.x))/slopeHeightfallof3.x,0.0,1.0);
						vSlope=/*1.0-*/(clamp(step(lParams3.z,dotNUp)+mfallof,0.0,1.0)*clamp(step(dotNUp,lParams3.x)+Mfallof,0.0,1.0));//clamp( pow((dotNUp-baseTexParams.x)/baseTexParams.x,baseFarCoords.z), 0.0,1.0);			// 4.0 - baseFarCoords.z = slope fallof
						Mfallof=1.0-clamp((NWheight-lParams3.y)/slopeHeightfallof3.y,0.0,1.0);
						mfallof=clamp((NWheight-(lParams3.w-slopeHeightfallof3.y))/slopeHeightfallof3.y,0.0,1.0);
						vSlopeHeight=vSlope*( clamp(step(lParams3.w,NWheight)+mfallof,0.0,1.0)*clamp(step(NWheight,lParams3.y)+Mfallof,0.0,1.0));
						fadedmask.b=vSlopeHeight*fadedmask.b;
						
					#endif
					
					fdcolor.xyz=blend3D(fdcolor,texcolor*dcolor3,fadedmask.b);
					fbcolor=texture2D(bmp3,vec2(texcoord[layerUV.w],texcoord[layerUV.w+1])*bscale3+bofs3);
					fnormal.xy=blend2D(fnormal.xy,(fbcolor.xy*2.0-1.0),fdcolor.a,texcolor.a,fadedmask.b);
					
				//	#ifndef MACROBUMP
						ffresnel.y=blend1D(ffresnel.y,fresnel3.y*fbcolor.z,fdcolor.a,texcolor.a,fadedmask.b);
						ffresnel.x=blend1D(ffresnel.x,fresnel3.x/*(fbcolor.a+SPECULAR_OFFSET)*/,fdcolor.a,texcolor.a,fadedmask.b);
				//	#endif
					
					metal=blend1D(metal,metal3*fbcolor.a,fdcolor.a,texcolor.a,fadedmask.b);//metal=mix(metal,metal3,fadedmask.b);//metal=metal3*fadedmask.b + (compMask.b)*metal;
					
				#endif

			#endif
		}
	#endif

	#ifdef MACROBUMP

		fnormal.z=0.0;
		fnormal=baseNormal.xyz+(fnormal*vec3(addBaseNormal.x));
		normalize(fnormal);
		ffresnel = mix(ffresnel,baseFresnel,vec2(addBaseNormal.y));
		metal = mix(metal,basemetal,addBaseNormal.y);
		
	#else
	
		// normalize resultant normal
		fnormal.z=sqrt(1.0-fnormal.x*fnormal.x-fnormal.y*fnormal.y);
	
	#endif
	
	#ifdef MACRODIFFUSE	
		fdcolor.rgb=mix(baseColor.rgb,baseColor.rgb*fdcolor.rgb,mulBaseDiffuse);
	#endif

	
	#ifdef _HEIGHTMAP_

		vec3 one=vec3(1.0,1.0,1.0);
		vec3 textureColor=pow(texture2D(cmask,texcoord.st).rgb,vec3(2.2));
		
		vec3 maskColor=textureColor;
		
		vec3 rmul=fdcolor.rgb*maskColor.rgb;
		vec3 rscr=one-((one-maskColor.rgb)*(one-fdcolor.rgb));
		fdcolor.rgb=fdcolor.rgb*rscr+(one-fdcolor.rgb)*rmul;
		
	#endif

	#ifndef _HEIGHTMAP_
		float scatterMask=texture2D(thickness,/*texcoord*/vec2(texcoord[maskUV.x],texcoord[maskUV.x+1])).r;
		fdcolor.a=scatterlevel.x*scatterMask;
	#else
		fnormal=normalize(normal3+vec3(fnormal.x,fnormal.y,0.0));//*4.0);
		fdcolor.a=0.0;
	#endif
	
	#ifdef VEGETATION
		#ifndef BSET
			#ifndef MSET
				vec3 one=vec3(1.0,1.0,1.0);
				vec3 rmul=fdcolor.rgb*vgColor.xyz;
				vec3 rscr=one-((one-vgColor.xyz)*(one-fdcolor.rgb));
				fdcolor.rgb=fdcolor.rgb*rscr+(one-fdcolor.rgb)*rmul;
			#endif
		#endif
	#endif
	
	float isNotMetal=step(metal,0.0); 	// if metal > 0 then isNotMetal = 0 else isNotMetal=1
	fdcolor.a*=isNotMetal;		  		// if metal then scatter is 0
	gl_FragData[0]=fdcolor;

	#ifdef PSYSTEM
			
		gl_FragData[1].xy=encode(vec3((fnormal.x*cosa)+(fnormal.y*sina),(fnormal.x*sina)-(fnormal.y*cosa),fnormal.z));
			
	#else
		
		#ifdef BSET
			
			vec3 one=vec3(1.0,1.0,1.0);
			vec3 rmul=gl_FragData[0].rgb*pcolor.xyz;
			vec3 rscr=one-((one-pcolor.xyz)*(one-gl_FragData[0].rgb));
			gl_FragData[0].rgb=gl_FragData[0].rgb*rscr+(one-gl_FragData[0].rgb)*rmul;
			gl_FragData[1].xy = encode(pnormal.xyz);

		#else
		
			// normal
			gl_FragData[1].xy=encode(TBN*fnormal.xyz);
			
			#ifdef MSET
			vec3 one=vec3(1.0,1.0,1.0);
			vec3 rmul=gl_FragData[0].rgb*pcolor.xyz;
			vec3 rscr=one-((one-pcolor.xyz)*(one-gl_FragData[0].rgb));
			gl_FragData[0].rgb=mix(gl_FragData[0].rgb,gl_FragData[0].rgb*rscr+(one-gl_FragData[0].rgb)*rmul,terrainColorAmount);
			#else
				#ifdef SKINNING
				#else
					#ifdef _HEIGHTMAP_
					#else
						gl_FragData[0]*=occlusion; 
					#endif
				#endif
			#endif
			
		#endif
			
	#endif
	
	gl_FragData[1].z=mix(ffresnel.x,0.0,( clamp( (-pos.z-rangeMin)/3000.0,0.0,1.0) ));// SPECULARITY
	gl_FragData[1].a=backScatter;
	
	// material params
	float M=mix(metal,matID,isNotMetal); // matID if isNotMetal=1 else metal
	
	gl_FragData[2].r=M;//scatterlevel*scatterMask; //COSINE POWER (SHININESS) //(floor(glossPow)*32.0 + floor(fspec.y));//fspec.x;	GlossScale=[0...32]
	gl_FragData[2].g=ffresnel.y; // ROUGHNESS
}
